var lastUserChkId = "";
var lastUserName = "";
var lastUserAuth = "";
var userTableCreated = false;

function userOnload() {
    toUserHome();
}

function toUserHome() {
    if (document.getElementById(lastUserChkId)) {
        document.getElementById(lastUserChkId).checked = false;
    }
    document.getElementById("editUserBtn").disabled = true;
    document.getElementById("delUserBtn").disabled = true;
    document.getElementById("editUserAuthSel").disabled = false;
    lastUserChkId = "";
    lastUserName = "";
    lastUserAuth = "";
    document.getElementById("Div_userHome").style.display = "block";
    document.getElementById("Div_userAdd").style.display = "none";
    document.getElementById("Div_userEdit").style.display = "none";
    document.getElementById("Div_userDel").style.display = "none";
    var tempArray = [
            "#addUserNameInput",
            "#addUserPasswordInput",
            "#addUserConfirmInput",
            "#editUserAdminInput",
            "#editUserPasswordInput",
            "#editUserConfirmInput",
            "#deleteUserConfirmInput"];
    for (x = 0; x < tempArray.length; x++) {
        $(tempArray[x]).val("");
    }
    $("#addUserAuthSel").val("1");
}

function toUserAdd() {
    document.getElementById("Div_userHome").style.display = "none";
    document.getElementById("Div_userAdd").style.display = "block";
    document.getElementById("Div_userEdit").style.display = "none";
    document.getElementById("Div_userDel").style.display = "none";
}

function toUserEdit() {
    var chkboxValue = document.getElementById("adminChkbox").checked;

    if (chkboxValue) {
        $("#editUserNameInput").val("admin");
        $("#editUserAuthSel").val("0").prop("disabled", true);
    } else {
        $("#editUserNameInput").val(lastUserName);
        if (lastUserAuth == "Administrator") {
            $("#editUserAuthSel").val("0");
        } else if (lastUserAuth == "Operator") {
            $("#editUserAuthSel").val("1");
        } else {
            $("#editUserAuthSel").val("2");
        }
    }
    document.getElementById("Div_userHome").style.display = "none";
    document.getElementById("Div_userAdd").style.display = "none";
    document.getElementById("Div_userEdit").style.display = "block";
    document.getElementById("Div_userDel").style.display = "none";
}

function toUserDel() {
    $("#confirmDelMsgSpan").text("Enter an admin password to remove User: " + lastUserName + ".");
    document.getElementById("Div_userHome").style.display = "none";
    document.getElementById("Div_userAdd").style.display = "none";
    document.getElementById("Div_userEdit").style.display = "none";
    document.getElementById("Div_userDel").style.display = "block";
}

function userChkboxClick(event, obj) {
    var index;
    var newId = obj.id;
    if (document.getElementById(newId).checked == true) {
        if (lastUserChkId != "") {
            document.getElementById(lastUserChkId).checked = false;
        } else {
            document.getElementById("editUserBtn").disabled = false;
        }
        lastUserChkId = newId;
        if (newId == "adminChkbox") {
            document.getElementById("delUserBtn").disabled = true;
            lastUserName = "";
            lastUserAuth = "";
        } else {
            if (cameraSettings.LoginUser == "admin") {
                document.getElementById("delUserBtn").disabled = false;
            }
            index = newId.replace("selUserChkbox", "");
            lastUserName = $("#userInput" + index).val();
            lastUserAuth = $("#authInput" + index).val();
        }
    } else {
        document.getElementById("editUserBtn").disabled = true;
        document.getElementById("delUserBtn").disabled = true;
        lastUserChkId = "";
        lastUserName = "";
        lastUserAuth = "";
    }
}

function createUserTable() {
    if (userTableCreated == false) {
        userTableCreated = true;
        for (var x = 1; x <= 15; x++) {
            var row = document.getElementById("editUserTr" + x);

            row.innerHTML = "<td class=\"chkbox_td\"><input id=\"selUserChkbox" + x + "\" type=\"checkbox\" class=\"ChkBox-16x16\" style=\"display:none\"><button id=\"addUserBtn" + x + "\" onclick=\"toUserAdd()\" class=\"Btn-Plus\" style=\"display:none\"></button></td>";
            row.innerHTML += "<td><input id=\"userInput" + x + "\" class=\"userInput\" disabled style=\"display:none\"></td>";
            row.innerHTML += "<td><input id=\"authInput" + x + "\" class=\"userInput\" disabled style=\"display:none\"></td>";

            $("#selUserChkbox" + x).on('click', function () {
                userChkboxClick(event, this);
            });
        }
    }
}

function updateUserTable() {
    var x;
    var UserInfo;
    var dataArray;
    var count = 0;
    var addUserBtn;
    var userInput;
    var authInput;
    var authName = ["Administrator", "Operator", "Viewer"];

    document.getElementById("editUserBtn").disabled = true;
    document.getElementById("delUserBtn").disabled = true;
    // reset user1~15
    for (x = 1; x <= 15; x++) {
        $("#selUserChkbox" + x).hide().prop("checked", false);
        $("#addUserBtn" + x).hide();
        $("#userInput" + x).hide().val("");
        $("#authInput" + x).hide().val("");
    }
    for (x = 1; x <= 15; x++) {
        UserInfo = "UserInfo" + x;
        dataArray = cameraSettings[UserInfo].split(",");
        //console.log(UserInfo + " = " + dataArray[0] + "," + dataArray[1]);

        // show edit user row
        if (dataArray[1] == "0" || dataArray[1] == "1" || dataArray[1] == "2") {
            count++;
            if (cameraSettings.LoginUser == "admin" || cameraSettings.LoginUser == dataArray[0] || dataArray[1] == "1" || dataArray[1] == "2") {
                $("#selUserChkbox" + count).show();
            }
            $("#userInput" + count).val(dataArray[0]).show();
            $("#authInput" + count).val(authName[Number(dataArray[1])]).show();
        }
    }
    // show add user row
    if (count < 15) {
        addUserBtn = "#addUserBtn" + (count + 1);
        userInput = "#userInput" + (count + 1);
        authInput = "#authInput" + (count + 1);
        $(addUserBtn).show();
        $(userInput).show();
        $(authInput).show();
    }
    if (cameraSettings.LoginUser == "admin") {
        $("#adminChkbox").show();
    } else {
        $("#adminChkbox").hide();
    }

    lastUserChkId = "";
    lastUserName = "";
    lastUserAuth = "";
}

function applyAddUser() {
    var username = $("#addUserNameInput").val();
    var password = $("#addUserPasswordInput").val();
    var confirm = $("#addUserConfirmInput").val();
    var auth = $("#addUserAuthSel").val();
    var cgiParam = {};
    warningMessage = "";

    if (username.length < 4 || username.length > 32) {
        warningMessage += getMessageWrongLength("User Name", 4, 32);
    } else if (username == "admin") {
        warningMessage += "This user already exists.<br>";
    } else {
        for (var x = 1; x <= 15; x++) {
            if (username == $("#userInput" + x).val()) {
                warningMessage += "This user already exists.<br>";
                break;
            }
        }
    }
    if (password.length < 4 || password.length > 32) {
        warningMessage += getMessageWrongLength("New Password", 4, 32);
    }
    if (password == "9999") {
        warningMessage += "You can't use password \"9999\"<br>";
    }
    if (password != confirm) {
        warningMessage += "Password mismatch.<br>";
    }
    if (warningMessage.length > 0) {
        showMessageModal("Warning", warningMessage, null);
        return;
    }

    addTime = 0;
    urlToSend = "/command/user.cgi?";

    AddParameter("AddUser", username + ":" + btoa(password) + "," + auth);

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send Add User Setting Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            console.log("Add User settings saved to " + cameraSettings.CameraName);
            reloadUser();
            UnblockUIforPage();
            showMessageModal("Message", getMessageAddUser(username), null);
        }
    });
}

function applyEditUser() {
    var adminPW = $("#editUserAdminInput").val();
    var oldName = $("#editUserNameInput").val();
    var newName = $("#editUserNameInput").val();
    var newPW = $("#editUserPasswordInput").val();
    var confirm = $("#editUserConfirmInput").val();
    var newAuth = $("#editUserAuthSel").val();
    var cgiParam = {};
    warningMessage = "";

    if (newPW.length < 4 || newPW.length > 32) {
        warningMessage += getMessageWrongLength("New Password", 4, 32);
    }
    if (newPW == "9999") {
        warningMessage += "You can't use password \"9999\"<br>";
    }
    if (newPW != confirm) {
        warningMessage += "Password mismatch.<br>";
    }
    if (warningMessage.length > 0) {
        showMessageModal("Warning", warningMessage, null);
        return;
    }

    addTime = 0;
    urlToSend = "/command/user.cgi?";

    if (oldName == "admin") {
        AddParameter("Administrator", "admin:" + btoa(adminPW) + ":" + btoa(newPW));
    } else {
        AddParameter("EditUser", btoa(adminPW) + ":" + oldName + ":" + newName + ":" + btoa(newPW) + "," + newAuth);
    }
    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send Edit User Setting Error");
            showMessageModal("Warning", "Password mismatch.", null);
        },
        success: function (response) {
            console.log("Edit User settings saved to " + cameraSettings.CameraName);
            UnblockUIforPage();
            if (oldName == "admin" || oldName == cameraSettings.LoginUser) {
                logout();
            } else {
                reloadUser();
            }
        }
    });
}

function applyDeleteUser() {
    var adminPW = $("#deleteUserConfirmInput").val();
    var userName = lastUserName;
    var cgiParam = {};
    addTime = 0;
    urlToSend = "/command/user.cgi?";

    AddParameter("DeleteUser", btoa(adminPW) + ":" + lastUserName);

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send Delete User Setting Error");
            showMessageModal("Warning", "Password mismatch.", null);
        },
        success: function (response) {
            console.log("Delete User settings saved to " + cameraSettings.CameraName);
            reloadUser();
            UnblockUIforPage();
        }
    });
}

function reloadUser() {
    openUser();
}

function openUser() {
    $("#DivMainPage").load("./page/user.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;
        userOnload();
        userTableCreated = false;

        $.ajax({
            url: "/command/inquiry.cgi?inqjs=main&inqjs=network&inqjs=system&inqjs=user",
            type: "GET",
            error: function (xhr) {
                console.log("Get user info fail");
            },
            success: function (response) {
                const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
                var result = [];
                while (result = regEx.exec(response)) {
                    cameraSettings[result[1]] = result[2];
                }

                createUserTable();
                updateUserTable();
                $("#applyAddUserBtn").on('click', applyAddUser);
                $("#applyEditUserBtn").on('click', applyEditUser);
                $("#applyDeleteUserBtn").on('click', applyDeleteUser);
            }
        });
    });
}
